/**
 * \file: SensorSourceChannel.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: AAuto
 *
 * \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
 *
 * \copyright (c) 2013-2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/
#include "SensorSourceChannel.h"

LOG_IMPORT_CONTEXT(demo)

namespace adit { namespace aauto {

SensorSourceChannel::SensorSourceChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId, uint32_t inLocationCharacterization)
 : sessionId(inSessionId), receiver(inReceiver), mLocationCharacterization(inLocationCharacterization)
{
}

SensorSourceChannel::~SensorSourceChannel()
{
    vsensor = nullptr;
}

void SensorSourceChannel::sensorWork(SensorType type)
{
    vsensor->setMode(type, aautoSensorWork);
}

void SensorSourceChannel::sensorBreak(SensorType type)
{
    vsensor->setMode(type, aautoSensorBreak);
}

void SensorSourceChannel::shutdown()
{
    LOG_INFO((demo, "sensor source channel shut down"));
    if(vsensor != nullptr)
    {
        vsensor->stop();
    }
    else
    {
        LOG_ERROR((demo, "SensorSourceChannel::shutdown() resource of sensor source is NULL"));
    }
}

bool SensorSourceChannel::Initialize(std::string inTestLocation)
{
    bool ret = false;

    LOGD_DEBUG((demo, "new SensorSource"));

    vsensor = ::shared_ptr<VirtualSensorSource> (new VirtualSensorSource(sessionId, receiver->messageRouter(), mLocationCharacterization));

    // enabled sensor for test
    vsensor->setConfigItem("enable-sensor-night-mode",           "0");
    vsensor->setConfigItem("enable-sensor-speed",                "0");
    vsensor->setConfigItem("enable-sensor-compass",              "0");
    vsensor->setConfigItem("enable-sensor-rpm",                  "0");
    vsensor->setConfigItem("enable-sensor-fuel",                 "0");
    vsensor->setConfigItem("enable-sensor-odometer",             "0");
    vsensor->setConfigItem("enable-sensor-parking-brake",        "0");
    vsensor->setConfigItem("enable-sensor-gear",                 "0");
    vsensor->setConfigItem("enable-sensor-door-data",            "0");
    vsensor->setConfigItem("enable-sensor-driving-status-data",  "1");
    vsensor->setConfigItem("enable-sensor-location",             "1");

    // cycle time for test
    vsensor->setConfigItem("test-loop-time",                "1000");    // set usec
    // enable logging for test
    vsensor->setConfigItem("enable-verbose-logging",        "0");
    // set test location
    vsensor->setConfigItem("test-location", inTestLocation);            // Set location(e.g."Hildesheim")

    if(vsensor->init())
    {
        LOGD_DEBUG((demo, "receiver->registerService <SensorSource>"));
        // The argument of API is done const_cast because GalReceiver requires non const pointer.
        ret = receiver->registerService(const_cast<SensorSource *> (vsensor->sensor.get()));
    }
    else
    {
        LOG_ERROR((demo, "Couldn't initialize sensorSource."));
    }

    return ret;
}

} } // namespace adit { namespace aauto
